/*
 * Decompiled with CFR 0.152.
 */
package ags.script.commands;

import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import ags.script.Engine;
import ags.script.InitalizationException;
import ags.script.Variable;
import ags.script.exception.FatalScriptException;
import java.io.PrintStream;

public class SetVariable
extends AbstractCommand {
    private String untranslatedValue = null;
    private Variable variable = null;
    private boolean prompt = false;

    protected void init(String[] args) throws InitalizationException {
        if (args.length < 3) {
            throw new InitalizationException("Set command called with too few arguments!");
        }
        if (args.length > 5) {
            throw new InitalizationException("Set command called with too many arguments!");
        }
        if (args.length == 5) {
            if ("?".equals(args[4])) {
                this.prompt = true;
            } else {
                throw new InitalizationException("Last parameter passed to Set command not understood: " + args[4]);
            }
        }
        String varDesc = args[1];
        String varName = args[2];
        if (args.length > 3) {
            this.untranslatedValue = args[3];
            this.trackVariableDependencies(this.untranslatedValue);
        } else {
            this.prompt = true;
        }
        this.variable = Variable.getVariable(varName);
        this.variable.setAccountedFor(true);
        this.variable.setDescription(varDesc);
        this.variable.setInitalized(false);
    }

    public void checkPaths() {
        String possibleValue;
        if (!this.prompt && (possibleValue = this.translateValue(this.untranslatedValue)) != null) {
            try {
                this.variable.setInitalized(false);
                this.variable.setValue(possibleValue);
            }
            catch (BadVariableValueException ex) {
                this.prompt = true;
                possibleValue = null;
                this.variable.setInitalized(false);
            }
        }
    }

    protected void doExecute() throws FatalScriptException {
        PrintStream out = Engine.getOut();
        String possibleValue = this.translateValue(this.untranslatedValue);
        if (possibleValue != null) {
            try {
                this.variable.setInitalized(true);
                this.variable.setValue(possibleValue);
            }
            catch (BadVariableValueException ex) {
                this.prompt = true;
                possibleValue = null;
            }
        }
        String enteredValue = possibleValue;
        while (this.prompt) {
            enteredValue = SetVariable.promptUser("Please enter " + this.variable.getDescription() + ": ", possibleValue);
            if (enteredValue != null && !"".equals(enteredValue)) {
                enteredValue = enteredValue.trim();
                out.println("User entry: " + enteredValue);
                enteredValue = enteredValue.trim();
                try {
                    this.variable.setInitalized(true);
                    this.variable.setValue(enteredValue);
                    this.prompt = false;
                }
                catch (BadVariableValueException ex) {
                    out.println("A task will fail if you use this value: " + ex.getMessage());
                    ex.printStackTrace(Engine.getLogOut());
                }
                continue;
            }
            out.println("No input received, please try again.");
        }
        this.variable.setInitalized(true);
    }

    protected void doDebugExecute() throws FatalScriptException {
        this.doExecute();
    }
}

